/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.activate;

import com.ibm.hwmca.base.activate.ActivateErrorIDs;
import com.ibm.hwmca.base.activate.ActivationTaskletData;
import com.ibm.hwmca.base.activate.ActivationTaskletTargetData;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;

public class ViewProfileBean
extends PanelBean {
    private static final String TRACE_MASKT = "XACTVPBT";
    private static final String TRACE_MASKF = "XACTVPBF";
    private static final String TRACE_MASKD = "XACTVPBD";
    private static final String REQUEST_EVENT = "event";
    private ItemDescriptor[][] m_idViewProfileTable;
    private ColumnDescriptor[] m_cdViewProfileTableStructure;
    private int[] m_iViewProfileTableSelection;
    private ActivationTaskletData atd;
    private static final int NUMBER_OF_COLUMNS = 3;

    public ViewProfileBean() {
        Trace.trace(TRACE_MASKD, "<> ViewProfileBean() constructor");
        this.setBeanName("ViewProfileBean");
    }

    public ViewProfileBean(ActivationTaskletData atd) {
        Trace.trace(TRACE_MASKD, "<> ViewProfileBean(ActivationTaskletData) constructor");
        Trace.trace(TRACE_MASKD, "  ActivationTaskletData = " + atd);
        this.atd = atd;
    }

    public void setViewProfileTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iViewProfileTableSelection = selected;
    }

    public int[] getViewProfileTableSelection() {
        return this.m_iViewProfileTableSelection;
    }

    public void setViewProfileTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKD, "-> setViewProfileTableRowAt(" + items + ")");
        Trace.trace(TRACE_MASKD, "Partition    name = " + items[0]);
        Trace.trace(TRACE_MASKD, "Next Profile name = " + items[1]);
        Trace.trace(TRACE_MASKD, "Last Profile name = " + items[2]);
        Trace.trace(TRACE_MASKD, "<- setViewProfileTableRowAt(" + items + ")");
        for (int i = 0; i < 3; ++i) {
            this.m_idViewProfileTable[index][i] = items[i];
        }
    }

    public ItemDescriptor[] getViewProfileTableRowAt(int index) {
        ItemDescriptor[] id = new ItemDescriptor[3];
        for (int i = 0; i < 3; ++i) {
            id[i] = this.m_idViewProfileTable[index][i];
        }
        Trace.trace(TRACE_MASKD, "-> getViewProfileTableRowAt(" + index + ") = " + this.m_idViewProfileTable[index]);
        Trace.trace(TRACE_MASKD, "Partition    name = " + id[0]);
        Trace.trace(TRACE_MASKD, "Next Profile name = " + id[1]);
        Trace.trace(TRACE_MASKD, "Last Profile name = " + id[2]);
        Trace.trace(TRACE_MASKD, "<- getViewProfileTableRowAt()");
        return id;
    }

    public int getViewProfileTableRowCount() {
        ActivationTaskletTargetData[] attd = this.atd.getActivationTaskletTargetData();
        Trace.trace(TRACE_MASKD, "Number of lines is " + attd.length);
        int numlines = attd.length;
        return numlines;
    }

    public int getViewProfileTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getViewProfileTableRowStructure() {
        return this.m_cdViewProfileTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public ActivationTaskletData getActivationTaskletData() {
        return this.atd;
    }

    public void setActivationTaskletData(ActivationTaskletData atd) {
        this.atd = atd;
    }

    public void load() {
        int i;
        ActivationTaskletTargetData[] attd = this.atd.getActivationTaskletTargetData();
        Trace.trace(TRACE_MASKD, "Number of lines is " + attd.length);
        int numlines = attd.length;
        this.m_idViewProfileTable = new ItemDescriptor[numlines][3];
        ItemDescriptor[] newRow = new ItemDescriptor[3];
        for (i = 0; i < numlines; ++i) {
            Trace.trace(TRACE_MASKD, "Partition    name[" + i + "] = " + attd[i].getName().trim());
            Trace.trace(TRACE_MASKD, "Next Profile name[" + i + "] = " + attd[i].getNextProfileName().trim());
            Trace.trace(TRACE_MASKD, "Last Profile name[" + i + "] = " + attd[i].getLastUsedProfileName().trim());
            newRow[0] = new ItemDescriptor("NAME" + i, attd[i].getName().trim());
            newRow[1] = new ItemDescriptor("NEXT" + i, attd[i].getNextProfileName().trim());
            String name = attd[i].getLastUsedProfileName().trim();
            if (name.length() == 0) {
                LocalizableText ltName = new LocalizableText("com/ibm/hwmca/base/res/text", "activate.nolastprof.text");
                name = ltName.toString();
            }
            newRow[2] = new ItemDescriptor("LAST" + i, name);
            this.setViewProfileTableRowAt(i, newRow);
        }
        Trace.trace(TRACE_MASKD, "Now dump the saved data for debug purposes");
        for (i = 0; i < numlines; ++i) {
            newRow = this.getViewProfileTableRowAt(i);
            Trace.trace(TRACE_MASKD, "Partition    name[" + i + "] = " + newRow[0]);
            Trace.trace(TRACE_MASKD, "Next Profile name[" + i + "] = " + newRow[1]);
            Trace.trace(TRACE_MASKD, "Last Profile name[" + i + "] = " + newRow[2]);
        }
        this.m_cdViewProfileTableStructure = new ColumnDescriptor[0];
        this.m_iViewProfileTableSelection = new int[0];
    }

    public void save() {
    }

    public void panelAction(TaskActionEvent tae) {
        Trace.trace(TRACE_MASKF, " -> panelAction()");
        try {
            String command = tae.getActionCommand();
            Trace.trace(TRACE_MASKF, "panel action = " + command);
            Trace.trace(TRACE_MASKF, "THIS = " + this);
            if (this.userTaskManager == null) {
                this.userTaskManager = (UserTaskManager)tae.getSource();
                Trace.trace(TRACE_MASKF, "userTaskManager = " + this.userTaskManager);
            }
            ViewProfileBean bean = (ViewProfileBean)this.userTaskManager.getDataObjects()[0];
            this.userTaskManager.storeAllElements();
            if (command.equals("CANCEL")) {
                Trace.trace(TRACE_MASKF, "Cancel");
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData(REQUEST_EVENT, tae);
                request.setData("beanname", this.getClass().getName());
                this.postTaskletRequest(request);
            } else if (command.endsWith("OkButton")) {
                Trace.trace(TRACE_MASKF, "SHOW DETAILS - the user double-clicked");
                int[] selection = bean.getViewProfileTableSelection();
                Trace.trace(TRACE_MASKF, "selection = " + selection);
                Trace.trace(TRACE_MASKF, "Number of selections = " + selection.length);
                if (selection.length == 0) {
                    Trace.trace(TRACE_MASKF, "Default selection to first item");
                    selection = new int[]{0};
                }
                ActivationTaskletData atdSelected = bean.getActivationTaskletData();
                Trace.trace(TRACE_MASKF, "atdSelected = " + atdSelected);
                ActivationTaskletTargetData[] attd = atdSelected.getActivationTaskletTargetData();
                Trace.trace(TRACE_MASKF, "attd = " + attd);
                Trace.trace(TRACE_MASKF, "Targets to look thru = " + attd.length);
                atdSelected.setShowDetailsFor(attd[selection[0]]);
                PanelTaskletRequest request = new PanelTaskletRequest();
                atdSelected.setCommand(3);
                request.setData("Key A", atdSelected);
                request.setData("beanname", this.getClass().getName());
                bean.postTaskletRequest(request);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "exception is " + e);
            new FrameworkLog(ActivateErrorIDs.LOGINFO, 18176, e).log();
        }
        Trace.trace(TRACE_MASKF, " <- panelAction()");
    }
}

